/** This file contains five schemata for processing arrays. Two of them 
    process a one-dimensional array segment from beginning to end. Two
    of them process a one-dimensional array segment from end to beginning.
    And the last one processes a two-dimensional array in row-major order.

    At written, this code will not compile.

    These schemata have been written as for loops, under the assumption
    that each element of the segment is to be processed in some way. 
    If there is any chance that this is not the case, then develop a while 
    loop instead of using one of these schemata.

    To use the one-dimensional array schemata, replace variables c, h, and k
    throughout the schemata by the ones you are using. Make the specification and
    invariant more concrete by explaining what "process" means. Finally, replace
    the body "Process c[i]".  You don't have to change the line beginning with for
    at all.


   1. To process each element of an array segment c[h..k-1], use the
    following program schema.

   Process c[h..k-1]
   //   invariant P: h <= i <= k  and
   //           c[h..i-1] has been processed
   for (int i= h; i != k; i++) {
      Process c[i]
   }

   2. To process each element of an array segment c[h..k], use the
   following program schema. This task (and resulting schema) is similar to the
   previous one, except that the index of the last element of the segment is 
   marked differently.

   Process c[h..k]
   // invariant P: h <= i <= k+1  and
   //           c[h..i-1] has been processed
   for (int i= h; i != k+1; i++) {
     Process c[i]
   }

// 3. To process each element of an array segment c[h..k-1], starting with the 
// last element of the segment and working toward the first, use the
// following program schema.

// Process c[h..k-1], from end to beginning
   // invariant P: h-1 <;= i < k  and
   //           c[i+1..k-1] has been processed
   for int (int i= k-1; i != h-1; i--) {
      Process c[i]
   }
   
// 4. To process each element of an array segment c[h..k], starting with the 
// last element of the segment and working toward the first, use the
// following program schema.

// Process c[h..k], from end to beginning
   // invariant P: h-1 <= i <= k  and
   //           c[i+1..k] has been processed
   for int (int i= k; i != h-1; i--) {
      Process c[i]
   }
   
// 5. To process each element of two-dimensional array d[0..][0..]
//    in row-major order, use this program schema.

// inv: d[0..r-1] and d[r][0..c-1] processed
   for (int r= 0; r != d.length; r++) 
      for (int c= 0; c != d[r].length; c++) {
         Process d[r][c]
      }
      
*/